<?php include('includes/header.php')?>
        <div class="custom-padding">
        <section class="container">
            <div class="hero-section row align-items-center mx-0 workforce-management-right-banner-img">
                <div class="row align-items-center">
                    <div class="col-lg-7" data-aos="fade-right">
                        <h2 class="fw-bold mb-3">WORKFORCE MANAGEMENT</h2>
                        <p>A complete, fully integrated Workforce Management solution custom-designed to meet the needs of the telecommunications industry, utility providers, companies in the energy sector, and large dispersed field operations. Enhance the ability to respond quickly, improve compliance, and increase overall operational efficiency from all perspectives on an ongoing basis (day-to-day, site-by-site, and team-by-team).</p>
                    </div>
                    
                </div>
            </div>
        </section>
        <section class="py-5">
            <div class="container">
                
                <div class="row align-items-center">
                    <div class="col-lg-5 text-center" data-aos="fade-right">
                                                 <img src="images/field-worker-lines-placeholder.png" class="img-fluid" alt="Field worker on power lines">
                    </div>
                    <div class="col-lg-7 mt-4 mt-lg-0">
                    <h2 class="mb-4 fw-bold pt-5">We are here, to help your fieldforce</h2>
                        <div class="feature-box me-5" data-aos="fade-right" data-aos-delay="200">
                            <div class="row">
                             <div class="col-sm-1"><span class="icon-check"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="20px" height="20px" viewBox="0 0 60 60" enable-background="new 0 0 60 60" xml:space="preserve">
<g>
	<path fill-rule="evenodd" clip-rule="evenodd" d="M54.732,8.12c1.17,0.415,1.954,1.217,1.902,2.854
		C43.019,21.14,33.877,35.779,29.047,54.732c-9.175-4.507-18.492-16.985-25.685-26.636c4.44,0,8.878,0,13.318,0
		c2.463,2.927,4.139,6.643,7.61,8.562C31.179,23.885,42.731,15.778,54.732,8.12z"/>
</g>
</svg></span></div> 
                             <div class="col-sm-11">
                             <p class="mb-0 text-start">Centralized control of all work orders, audits, incidents, maintenance tasks, and training activities</p>
                             </div>
                        </div>
                        </div>
                        <div class="feature-box ms-5" data-aos="fade-right" data-aos-delay="300">
                            <div class="row">
                             <div class="col-sm-1"><span class="icon-check"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="20px" height="20px" viewBox="0 0 60 60" enable-background="new 0 0 60 60" xml:space="preserve">
<g>
	<path fill-rule="evenodd" clip-rule="evenodd" d="M54.732,8.12c1.17,0.415,1.954,1.217,1.902,2.854
		C43.019,21.14,33.877,35.779,29.047,54.732c-9.175-4.507-18.492-16.985-25.685-26.636c4.44,0,8.878,0,13.318,0
		c2.463,2.927,4.139,6.643,7.61,8.562C31.179,23.885,42.731,15.778,54.732,8.12z"/>
</g>
</svg></span></div> 
                             <div class="col-sm-11">
                             <p class="mb-0 text-start">Real-time visibility into field operations, task progress, and workforce productivity</p>
                             </div>
                        </div>
                        </div>
                        <div class="feature-box me-5" data-aos="fade-right" data-aos-delay="400">
                            <div class="row">
                             <div class="col-sm-1"><span class="icon-check"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="20px" height="20px" viewBox="0 0 60 60" enable-background="new 0 0 60 60" xml:space="preserve">
<g>
	<path fill-rule="evenodd" clip-rule="evenodd" d="M54.732,8.12c1.17,0.415,1.954,1.217,1.902,2.854
		C43.019,21.14,33.877,35.779,29.047,54.732c-9.175-4.507-18.492-16.985-25.685-26.636c4.44,0,8.878,0,13.318,0
		c2.463,2.927,4.139,6.643,7.61,8.562C31.179,23.885,42.731,15.778,54.732,8.12z"/>
</g>
</svg></span></div> 
                             <div class="col-sm-11">
                             <p class="mb-0 text-start">Standardized processes & compliance through digital checklists, guided workflows, and evidence capture</p>
                             </div>
                        </div>
                        </div>
                        <div class="feature-box ms-5" data-aos="fade-right" data-aos-delay="500">
                            <div class="row">
                             <div class="col-sm-1"><span class="icon-check"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="20px" height="20px" viewBox="0 0 60 60" enable-background="new 0 0 60 60" xml:space="preserve">
<g>
	<path fill-rule="evenodd" clip-rule="evenodd" d="M54.732,8.12c1.17,0.415,1.954,1.217,1.902,2.854
		C43.019,21.14,33.877,35.779,29.047,54.732c-9.175-4.507-18.492-16.985-25.685-26.636c4.44,0,8.878,0,13.318,0
		c2.463,2.927,4.139,6.643,7.61,8.562C31.179,23.885,42.731,15.778,54.732,8.12z"/>
</g>
</svg></span></div> 
                             <div class="col-sm-11">
                             <p class="mb-0 text-start">High scalability to manage thousands of sites, users, and daily field operations</p>
                             </div>
                        </div>
                        </div>
                        <div class="feature-box me-5" data-aos="fade-right" data-aos-delay="600">
                            <div class="row">
                             <div class="col-sm-1"><span class="icon-check"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="20px" height="20px" viewBox="0 0 60 60" enable-background="new 0 0 60 60" xml:space="preserve">
<g>
	<path fill-rule="evenodd" clip-rule="evenodd" d="M54.732,8.12c1.17,0.415,1.954,1.217,1.902,2.854
		C43.019,21.14,33.877,35.779,29.047,54.732c-9.175-4.507-18.492-16.985-25.685-26.636c4.44,0,8.878,0,13.318,0
		c2.463,2.927,4.139,6.643,7.61,8.562C31.179,23.885,42.731,15.778,54.732,8.12z"/>
</g>
</svg></span></div> 
                             <div class="col-sm-11">
                             <p class="mb-0 text-start">Seamless collaboration among field teams, supervisors, back-office staff, and leadership</p>
                             </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
		<section class="py-5 pt-0">
            <div class="container">
                <h2 class="mb-4 fw-bold">Benefits that the application provides</h2>
                <div class="row g-4">
    <div class="col-md-4" data-aos="fade-up">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="30px" height="30px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
<g>
	<path fill="#FECE09" d="M273.496,192.994h253.008c12.65,0,23.001-10.351,23.001-23.001v-46.001
		c0-37.951-31.051-69.002-69.002-69.002H319.498c-37.952,0-69.002,31.051-69.002,69.002v46.001
		C250.495,182.643,260.846,192.994,273.496,192.994z"/>
</g>
<path fill="#FECE09" d="M653.008,112.491h-23.001c-6.899,0-11.5,4.6-11.5,11.5v46.001c0,50.602-41.401,92.003-92.003,92.003H273.496
	c-50.602,0-92.003-41.401-92.003-92.003v-46.001c0-6.9-4.601-11.5-11.5-11.5h-23c-37.951,0-69.002,31.051-69.002,69.002v494.516
	c0,37.951,31.051,69.002,69.002,69.002h506.016c37.952,0,69.002-31.051,69.002-69.002V181.493
	C722.01,143.542,690.96,112.491,653.008,112.491z M593.207,388.5L372.399,609.306c-5.75,5.75-12.65,9.201-20.7,9.201
	c-8.051,0-16.101-3.451-21.851-9.201L206.794,486.253c-5.75-5.75-5.75-12.65,0-18.4l24.151-24.15c5.75-5.75,12.65-5.75,18.401,0
	l101.202,101.202l198.957-198.956c5.75-5.75,12.649-5.75,18.4,0l24.15,24.151C597.806,375.85,597.806,383.899,593.207,388.5z"/>
</svg>
        </div>
        <h5 class="fw-bold">End-to-End Work Order Management</h5>
        <ul>
        <li>Intelligent work order templates</li>
        <li>Auto-assignment based on skills, location, or workload</li>
        <li>Geo-tagged photos & evidence-based task closure</li>
		</ul>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="30px" height="30px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
<g>
	<g>
		<g>
			<path fill="#FECE09" d="M716.737,80.461H85.268c-34.799,0-63.107,28.311-63.107,63.109v411.559
				c0,34.799,28.309,63.11,63.107,63.11h203.461l-38.617,85.153c-3.987,8.795-3.237,19.013,1.995,27.128
				c5.232,8.116,14.226,13.019,23.88,13.019h250.029c0.011,0,0.026,0,0.037,0c15.694,0,28.413-12.719,28.413-28.413
				c0-4.723-1.146-9.184-3.193-13.101l-38.002-83.786h203.461c34.799,0,63.108-28.312,63.108-63.11V143.57
				C779.845,108.771,751.536,80.461,716.737,80.461z M723.02,555.131c0,3.465-2.819,6.281-6.282,6.281H469.191H332.815H85.268
				c-3.462,0-6.281-2.816-6.281-6.281V143.57c0-3.464,2.819-6.283,6.281-6.283h631.467c3.463,0,6.282,2.819,6.282,6.283
				L723.02,555.131L723.02,555.131z"/>
			<path fill="#FECE09" d="M629.49,164.484c-30.683,0-55.641,24.962-55.641,55.645c0,2.832,0.216,5.614,0.625,8.334l-129.962,75.83
				c-10.134-10.561-24.367-17.156-40.127-17.156c-19.66,0-36.961,10.259-46.857,25.692l-129.617-50.729
				c0.155-1.684,0.244-3.385,0.244-5.106c0-30.683-24.958-55.646-55.641-55.646c-30.682,0-55.644,24.964-55.644,55.646
				c0,30.682,24.962,55.643,55.645,55.643c15.403,0,29.362-6.297,39.451-16.444l137.249,53.718
				c3.512,27.324,26.905,48.513,55.171,48.513c30.683,0,55.645-24.962,55.645-55.643c0-1.333-0.069-2.654-0.159-3.962
				l132.477-77.299c9.856,8.854,22.875,14.254,37.139,14.254c30.683,0,55.645-24.962,55.645-55.644
				C685.133,189.446,660.173,164.484,629.49,164.484z M172.516,275.078c-9.973,0-18.084-8.113-18.084-18.083
				c0-9.973,8.111-18.086,18.084-18.086c9.967,0,18.082,8.113,18.082,18.086C190.598,266.965,182.483,275.078,172.516,275.078z
				 M404.386,360.863c-9.975,0-18.084-8.111-18.084-18.083c0-9.973,8.11-18.084,18.084-18.084c9.976,0,18.084,8.113,18.084,18.084
				S414.361,360.863,404.386,360.863z M629.49,238.213c-9.97,0-18.086-8.113-18.086-18.084c0-9.972,8.116-18.086,18.086-18.086
				c9.972,0,18.084,8.114,18.084,18.086C647.574,230.1,639.462,238.213,629.49,238.213z"/>
			<path fill="#FECE09" d="M591.2,296.782l-110.739,64.613c-3.826,35.803-32.447,64.293-68.307,67.928v97.882h255.51v-230.38
				c-11.248,6.505-24.276,10.248-38.174,10.248C615.937,307.071,602.765,303.479,591.2,296.782z"/>
			<path fill="#FECE09" d="M331.275,375.73l-115.498-45.203c-12.647,8.719-27.595,13.409-43.264,13.409
				c-13.899,0-26.93-3.743-38.174-10.244v193.513h255.508v-98.894C362.262,422.953,339.57,402.65,331.275,375.73z"/>
		</g>
	</g>
</g>
</svg>
        </div>
        <h5 class="fw-bold">Audits & Quality Compliance</h5>
        <ul>
            <li>Fully customizable digital audits</li>
            <li>Geo-verified site visits</li>
            <li>Offline audit execution</li>
            <li>Compliance scoring, patterns, and trend analysis</li>
        </ul>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="30px" height="30px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
<g>
	<path fill="#FECE09" d="M738.018,216.881l-53.649-10.734c-2.715-3.101-6.052-5.598-9.764-7.353
		c4.219-4.716,7.803-9.484,10.523-13.432c6.56-9.516,12.022-19.77,15.814-29.657c1.862-4.17,3.44-8.363,4.74-12.472
		c5.08-4.267,8.071-10.642,8.071-17.326v-16.377c0-4.708-1.467-9.297-4.183-13.115v-23.06C709.57,32.905,676.662,0,636.211,0
		h-23.783c-40.442,0-73.356,32.905-73.356,73.354v23.062c-2.707,3.816-4.188,8.408-4.188,13.111v16.377
		c0,6.685,2.987,13.048,8.081,17.322c1.294,4.104,2.88,8.302,4.745,12.483c3.781,9.882,9.247,20.136,15.813,29.646
		c2.726,3.959,6.31,8.731,10.548,13.468c-3.702,1.756-7.015,4.247-9.726,7.334l-52.524,10.64c-0.297,0.392-0.588,0.789-0.895,1.173
		c-0.956,2.539-1.979,5.049-3.062,7.515c-1.427,3.649-3.021,7.325-4.776,10.993l16.877,3.374
		c29.927,5.985,51.646,32.485,51.646,63.015V496.63c0,6.414-0.929,12.671-2.767,18.692v15.104c0,25.45-15.787,47.275-38.083,56.203
		v109.722c0,25.967,21.053,47.019,47.023,47.019c25.959,0,47.01-21.05,47.01-47.019c0,25.967,21.045,47.019,47.022,47.019
		c25.958,0,47.003-21.05,47.003-47.019V495.731c4.12,2.688,9.026,4.26,14.307,4.26c14.477,0,26.188-11.729,26.188-26.19v-21.24
		c1.78-3.816,2.769-8.07,2.769-12.555V246.239C762.08,231.968,752.005,219.677,738.018,216.881z M610.247,265.974
		c-0.198,1.918-1.548,3.526-3.418,4.042c-0.42,0.121-0.836,0.171-1.259,0.171c-1.452,0-2.854-0.67-3.753-1.866l-13.215-17.526
		c-0.611-0.815-0.947-1.811-0.947-2.833l0.015-28.09c0.004-1.648,0.869-3.177,2.282-4.033c1.405-0.851,3.16-0.89,4.624-0.126
		c3.838,2.037,7.685,3.404,11.411,4.061c2.241,0.405,3.874,2.356,3.874,4.631v11.722c0.68,0.269,1.284,0.68,1.776,1.229
		c0.894,0.992,1.326,2.31,1.188,3.628L610.247,265.974z M660.021,250.792l-13.188,17.51c-0.909,1.2-2.306,1.881-3.754,1.881
		c-0.422,0-0.853-0.061-1.272-0.17c-1.866-0.518-3.22-2.126-3.416-4.05l-2.57-24.985c-0.138-1.318,0.288-2.635,1.183-3.628
		c0.49-0.55,1.094-0.96,1.777-1.229v-11.722c0-2.277,1.636-4.227,3.883-4.631c3.71-0.656,7.555-2.021,11.4-4.058
		c1.469-0.765,3.215-0.722,4.622,0.126c1.42,0.852,2.272,2.384,2.272,4.033l0.006,28.094
		C660.965,248.985,660.634,249.98,660.021,250.792z M664.807,170.757c-11.501,16.68-22.27,24.143-27.858,24.143h-25.253
		c-5.585,0-16.364-7.464-27.861-24.143c-9.068-13.161-15.38-27.719-16.86-38.956l-0.258-1.948l-4.565-2.962
		c-1.334-0.871-2.142-2.349-2.142-3.948v-7.731c0-2.598,2.111-4.707,4.707-4.707h1.915v-8.387c0-1.783,1.008-3.406,2.601-4.206
		c6.474-3.223,19.324-8.653,32.627-8.653c10.603,0,19.401,3.532,26.146,10.491c8.395,8.69,18.088,13.087,28.77,13.087
		c6.068,0,12.318-1.426,18.605-4.25c1.454-0.651,3.144-0.523,4.488,0.348c0.629,0.403,1.127,0.943,1.496,1.569h2.564
		c2.598,0,4.709,2.109,4.709,4.707v7.733c0,1.597-0.813,3.075-2.141,3.946l-4.561,2.964l-0.266,1.942
		C680.188,143.035,673.875,157.596,664.807,170.757z"/>
	<path fill="#FECE09" d="M231.149,530.428v-15.133c-1.833-6.02-2.759-12.268-2.759-18.661V302.837
		c0-30.452,21.662-56.943,51.502-62.983l16.132-3.266c-1.773-3.708-3.389-7.422-4.824-11.105c-1.088-2.477-2.111-4.986-3.063-7.513
		c-0.353-0.444-0.693-0.897-1.033-1.354l-52.323-10.467c-2.713-3.101-6.048-5.598-9.761-7.353c4.22-4.716,7.8-9.485,10.522-13.432
		c6.562-9.516,12.023-19.77,15.813-29.657c1.864-4.17,3.441-8.363,4.743-12.473c5.078-4.267,8.073-10.641,8.073-17.326V109.53
		c0-4.709-1.469-9.297-4.182-13.115V73.354C259.989,32.905,227.077,0,186.622,0h-23.78C122.4,0,89.49,32.905,89.49,73.354v23.062
		c-2.713,3.816-4.195,8.408-4.195,13.111v16.377c0,6.685,2.993,13.048,8.085,17.322c1.292,4.104,2.876,8.302,4.744,12.483
		c3.778,9.882,9.245,20.136,15.809,29.646c2.729,3.959,6.311,8.731,10.548,13.468c-3.701,1.756-7.017,4.247-9.724,7.334
		L61.91,216.864c-13.954,2.826-23.99,15.092-23.99,29.343v193.8c0,4.484,0.994,8.74,2.759,12.555v21.24
		c0,14.461,11.722,26.19,26.192,26.19c5.273,0,10.192-1.573,14.301-4.26v200.62c0,25.968,21.051,47.019,47.022,47.019
		c25.958,0,47.009-21.049,47.009-47.019c0,25.968,21.043,47.019,47.026,47.019c25.957,0,47-21.049,47-47.019V586.629
		C246.939,577.699,231.149,555.872,231.149,530.428z M160.66,265.974c-0.199,1.918-1.547,3.526-3.417,4.042
		c-0.419,0.121-0.837,0.171-1.259,0.171c-1.456,0-2.856-0.67-3.75-1.866l-13.215-17.526c-0.615-0.815-0.945-1.811-0.945-2.833
		l0.011-28.09c0.004-1.648,0.871-3.177,2.284-4.033c1.404-0.851,3.158-0.89,4.62-0.126c3.842,2.037,7.689,3.404,11.414,4.061
		c2.239,0.405,3.875,2.356,3.875,4.631v11.722c0.674,0.269,1.281,0.68,1.775,1.229c0.891,0.992,1.324,2.31,1.188,3.628
		L160.66,265.974z M210.436,250.792l-13.189,17.51c-0.906,1.2-2.304,1.881-3.754,1.881c-0.421,0-0.85-0.061-1.27-0.17
		c-1.862-0.518-3.218-2.126-3.415-4.05l-2.57-24.985c-0.138-1.318,0.29-2.635,1.179-3.628c0.49-0.55,1.095-0.96,1.78-1.229v-11.722
		c0-2.277,1.636-4.227,3.879-4.631c3.714-0.656,7.556-2.021,11.405-4.058c1.465-0.765,3.214-0.722,4.622,0.126
		c1.42,0.852,2.273,2.384,2.273,4.033l0.003,28.094C211.377,248.985,211.05,249.98,210.436,250.792z M215.217,170.757
		c-11.5,16.68-22.264,24.143-27.853,24.143h-25.258c-5.582,0-16.36-7.464-27.856-24.143c-9.073-13.161-15.384-27.719-16.864-38.956
		l-0.26-1.948l-4.562-2.962c-1.333-0.871-2.141-2.349-2.141-3.948v-7.731c0-2.598,2.108-4.707,4.706-4.707h1.914v-8.387
		c0-1.783,1.014-3.406,2.605-4.206c6.477-3.223,19.322-8.653,32.624-8.653c10.603,0,19.404,3.532,26.148,10.491
		c8.396,8.69,18.089,13.087,28.771,13.087c6.068,0,12.316-1.426,18.604-4.25c1.456-0.651,3.142-0.523,4.486,0.348
		c0.627,0.403,1.127,0.943,1.499,1.569h2.564c2.598,0,4.709,2.109,4.709,4.707v7.733c0,1.597-0.813,3.075-2.145,3.946l-4.559,2.964
		l-0.264,1.942C230.601,143.035,224.292,157.596,215.217,170.757z"/>
	<path fill="#FECE09" d="M534.521,509.188c1.78-3.813,2.769-8.071,2.769-12.556V302.867c0-14.271-10.077-26.564-24.061-29.362
		l-53.651-10.732c-2.713-3.101-6.052-5.601-9.763-7.352c4.22-4.72,7.798-9.486,10.522-13.432c6.56-9.518,12.022-19.77,15.811-29.661
		c1.866-4.17,3.442-8.361,4.74-12.474c5.079-4.264,8.077-10.642,8.077-17.326V166.15c0-4.707-1.469-9.297-4.185-13.115v-23.054
		c0-40.449-32.909-73.352-73.359-73.352h-23.784c-40.443,0-73.354,32.903-73.354,73.352v23.062
		c-2.711,3.816-4.192,8.408-4.192,13.111v16.377c0,6.685,2.991,13.048,8.085,17.323c1.294,4.104,2.876,8.305,4.744,12.483
		c3.778,9.886,9.243,20.137,15.809,29.649c2.728,3.959,6.31,8.731,10.549,13.464c-3.702,1.757-7.016,4.25-9.723,7.336
		l-52.849,10.707c-13.954,2.824-23.99,15.092-23.99,29.345v193.797c0,4.484,0.993,8.742,2.757,12.556v21.24
		c0,14.461,11.722,26.194,26.192,26.194c5.275,0,10.192-1.574,14.299-4.262v200.615c0,25.97,21.055,47.021,47.026,47.021
		c25.956,0,47.009-21.049,47.009-47.021c0,25.97,21.04,47.021,47.022,47.021c25.958,0,46.998-21.049,46.998-47.021v-200.62
		c4.12,2.688,9.031,4.263,14.313,4.263c14.47,0,26.187-11.733,26.187-26.194v-21.24H534.521z M385.453,322.603
		c-0.197,1.918-1.549,3.522-3.415,4.041c-0.418,0.119-0.838,0.17-1.259,0.17c-1.456,0-2.857-0.67-3.751-1.866l-13.219-17.53
		c-0.612-0.813-0.945-1.811-0.945-2.833l0.015-28.09c0.004-1.651,0.867-3.177,2.282-4.033c1.406-0.85,3.162-0.893,4.622-0.128
		c3.842,2.039,7.686,3.404,11.414,4.063c2.237,0.403,3.873,2.356,3.873,4.631v11.718c0.678,0.273,1.283,0.683,1.777,1.229
		c0.891,0.993,1.321,2.31,1.185,3.63L385.453,322.603z M435.229,307.418l-13.19,17.513c-0.904,1.198-2.301,1.879-3.753,1.879
		c-0.422,0-0.851-0.062-1.272-0.171c-1.86-0.522-3.214-2.126-3.41-4.052l-2.57-24.983c-0.138-1.32,0.288-2.637,1.178-3.63
		c0.49-0.546,1.099-0.957,1.78-1.229v-11.718c0-2.276,1.638-4.228,3.879-4.631c3.716-0.658,7.556-2.022,11.406-4.059
		c1.464-0.763,3.216-0.721,4.622,0.13c1.42,0.851,2.274,2.38,2.274,4.033l0.002,28.092
		C436.172,305.611,435.843,306.606,435.229,307.418z M440.008,227.387c-11.495,16.676-22.263,24.141-27.853,24.141h-25.258
		c-5.582,0-16.36-7.466-27.856-24.141c-9.07-13.161-15.384-27.719-16.863-38.96l-0.258-1.946l-4.563-2.963
		c-1.335-0.869-2.142-2.347-2.142-3.944v-7.732c0-2.6,2.106-4.707,4.706-4.707h1.914v-8.387c0-1.785,1.01-3.409,2.602-4.208
		c6.477-3.226,19.325-8.653,32.628-8.653c10.603,0,19.404,3.531,26.147,10.493c8.396,8.687,18.088,13.087,28.77,13.087
		c6.068,0,12.318-1.428,18.605-4.25c1.454-0.654,3.139-0.524,4.484,0.343c0.628,0.407,1.127,0.943,1.501,1.573h2.563
		c2.598,0,4.707,2.105,4.707,4.707v7.734c0,1.597-0.811,3.075-2.141,3.944l-4.559,2.963l-0.264,1.944
		C455.396,199.663,449.084,214.226,440.008,227.387z"/>
</g>
</svg>
        </div>
        <h5 class="fw-bold">Training & TBT (Toolbox Talk) Management</h5>
        <ul>
            <li>Training requests, scheduling & approvals</li>
            <li>Attendance tracking & performance assessments</li>
            <li>TBT compliance logs</li>
            <li>Export-ready training & competency analytics</li>
		 </ul>
      </div>
    </div>
  </div>
  <div class="row g-4 mt-4">
    <div class="col-md-4" data-aos="fade-up">
      <div class="why-us-card">
       <div class="why-us-icon">
          <svg version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="30px" height="40px" viewBox="0 96.5 800 612" enable-background="new 0 96.5 800 612" xml:space="preserve">
<g>
	<path fill="#FECE09" d="M400.005,127.748C192.064,127.748,23.5,296.314,23.5,504.256c0,60.372,14.245,117.411,39.5,167.996h674.001
		c25.267-50.585,39.498-107.626,39.498-167.996C776.5,296.314,607.936,127.748,400.005,127.748z M400.005,170.654
		c20.565,0,37.279,16.688,37.279,37.278s-16.714,37.278-37.279,37.278c-20.59,0-37.277-16.688-37.277-37.278
		S379.417,170.654,400.005,170.654z M103.684,541.533c-20.59,0-37.278-16.688-37.278-37.277s16.688-37.278,37.278-37.278
		c20.565,0,37.28,16.688,37.28,37.278C140.962,524.844,124.249,541.533,103.684,541.533z M216.827,321.075
		c-14.553,14.566-38.153,14.566-52.72,0c-14.541-14.554-14.541-38.155,0-52.707c14.566-14.554,38.167-14.554,52.72,0
		C231.379,282.92,231.379,306.521,216.827,321.075z M501.348,279.13l-44.24,215.076c7.234,10.863,11.454,23.898,11.454,37.932
		c0,37.859-30.698,68.559-68.556,68.559c-37.871,0-68.569-30.699-68.569-68.559c0-31.599,21.416-58.138,50.509-66.075
		l108.253-191.104c1.471-2.58,4.592-3.715,7.371-2.679C500.336,273.328,501.94,276.242,501.348,279.13z M635.894,321.075
		c-14.555,14.566-38.167,14.566-52.721,0c-14.54-14.554-14.54-38.155,0-52.707c14.554-14.554,38.166-14.554,52.721,0
		C650.434,282.92,650.434,306.521,635.894,321.075z M696.329,541.533c-20.589,0-37.277-16.688-37.277-37.277
		s16.688-37.278,37.277-37.278c20.563,0,37.278,16.688,37.278,37.278C733.605,524.844,716.893,541.533,696.329,541.533z"/>
	<path fill="#FECE09" d="M400.005,505.415c-14.762,0-26.735,11.962-26.735,26.723c0,14.764,11.973,26.726,26.735,26.726
		c14.763,0,26.725-11.96,26.725-26.726C426.731,517.377,414.769,505.415,400.005,505.415z"/>
</g>
</svg>
        </div>
        <h5 class="fw-bold">Meter Reading Digitization</h5>
        <ul>
            <li>Photo-verified meter readings</li>
            <li>Automated data validation</li>
            <li>Complete historical logs</li>
            <li>Bulk upload support</li>
        </ul>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="30px" height="30px" viewBox="0 98.5 800 608" enable-background="new 0 98.5 800 608" xml:space="preserve">
<g>
	<path fill="#FECE09" d="M472.273,497.551h-70.846H276.116H79.78V176.375h517.976v78.515c4.792-0.337,9.742-0.526,14.893-0.526
		c14.718,0,28.021,1.48,39.943,4.368V146.439c0-9.335-7.573-16.902-16.907-16.902H41.866c-9.341,0-16.906,7.567-16.906,16.902
		v381.052c0,9.335,7.565,16.906,16.906,16.906h209.773c-3.735,22.537-12.314,62.598-30.463,102.114
		c-2.403,5.229-1.979,11.324,1.133,16.177c3.112,4.849,8.475,7.777,14.229,7.777h190.304c-1.632-5.077-2.113-10.51-1.244-15.913
		c3.055-19.006,6.879-39.998,11.514-60.6c-5.683-19.769-9.181-37.274-11.219-49.556h24.604
		C456.809,525.251,464.052,508.741,472.273,497.551z"/>
	<path fill="#FECE09" d="M498.822,282.606c15.574,0,28.244-12.667,28.244-28.244c0-15.572-12.67-28.241-28.244-28.241
		s-28.243,12.668-28.243,28.241c0,1.46,0.144,2.882,0.36,4.284L340.68,358.8c-3.468-1.525-7.295-2.386-11.32-2.386
		c-5.353,0-10.344,1.522-14.614,4.12l-111.988-64.569c0.003-0.193,0.029-0.378,0.029-0.571c0-15.574-12.666-28.243-28.244-28.243
		c-15.57,0-28.243,12.669-28.243,28.243c0,15.572,12.673,28.243,28.243,28.243c5.353,0,10.344-1.522,14.614-4.12l111.988,64.57
		c-0.004,0.193-0.029,0.378-0.029,0.57c0,15.575,12.669,28.246,28.243,28.246c15.579,0,28.247-12.671,28.247-28.246
		c0-1.462-0.146-2.885-0.362-4.288l130.255-100.148C490.969,281.746,494.794,282.606,498.822,282.606z"/>
	<path fill="#FECE09" d="M774.963,657.995c-5.554-34.533-20.774-117.852-42.134-145.571c-11.078-14.388-54.79-38.17-63.442-42.791
		c-2.096-1.117-4.66-0.896-6.537,0.574c-9.634,7.562-20.184,12.66-31.365,15.148c-1.974,0.439-3.595,1.844-4.309,3.735
		l-11.388,30.001l-11.38-30.001c-0.719-1.892-2.335-3.296-4.31-3.735c-11.182-2.486-21.728-7.587-31.365-15.148
		c-1.875-1.47-4.438-1.696-6.54-0.574c-8.648,4.624-52.365,28.407-63.443,42.791c-21.359,27.722-36.579,111.036-42.133,145.571
		c-0.278,1.738,0.216,3.515,1.361,4.849c1.137,1.342,2.813,2.114,4.576,2.114h306.477c1.761,0,3.431-0.772,4.576-2.114
		C774.746,661.51,775.244,659.733,774.963,657.995z"/>
	<path fill="#FECE09" d="M530.944,351.11c-9.473,5.043-20.766,13.44-25.732,26.319c-4.834,12.529-2.793,26.453,6.044,41.42
		c-0.609,2.688-0.164,5.601,1.536,8.035l3.595,5.137c1.891,2.703,4.991,4.315,8.292,4.315c2.079,0,4.081-0.629,5.793-1.827
		c2.215-1.548,3.688-3.865,4.161-6.523c0.468-2.662-0.127-5.346-1.673-7.562l-3.599-5.141c-1.345-1.924-3.312-3.283-5.522-3.912
		c-6.412-10.887-8.093-20.509-4.976-28.627c2.172-5.67,6.421-10.217,11.091-13.753c-0.064,3.067-0.1,6.178-0.1,9.324
		c0,53.437,38.478,96.756,85.936,96.756c47.465,0,85.938-43.317,85.938-96.756c0-53.436-7.812-96.755-85.938-96.755
		C551.483,281.561,534.828,310.921,530.944,351.11z"/>
</g>
        </div>
        <h5 class="fw-bold">Audits & Quality Compliance</h5>
        <ul>
        <li>Fully customizable digital audits</li>
        <li>Geo-verified site visits</li>
        <li>Offline audit execution</li>
        <li>Compliance scoring, patterns, and trend analysis</li>
        </ul>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="30px" height="30px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
<path fill="#FECE09" d="M311.875,47.5c-24.441,0-44.063,19.622-44.063,44.063V223.75c0,24.441,19.622,44.063,44.063,44.063h44.063
	v88.125H47.5v88.125h88.125v88.125H91.563c-24.441,0-44.063,19.622-44.063,44.063v132.188c0,24.441,19.622,44.063,44.063,44.063
	h176.25c24.441,0,44.063-19.621,44.063-44.063V576.25c0-24.44-19.622-44.063-44.063-44.063H223.75v-88.125h352.5v88.125h-44.063
	c-24.441,0-44.063,19.622-44.063,44.063v132.188c0,24.441,19.621,44.063,44.063,44.063h176.25c24.441,0,44.063-19.621,44.063-44.063
	V576.25c0-24.44-19.621-44.063-44.063-44.063h-44.063v-88.125H752.5v-88.125H444.063v-88.125h44.063
	c24.441,0,44.063-19.622,44.063-44.063V91.563c0-24.441-19.621-44.063-44.063-44.063H311.875z"/>
</svg>
        </div>
        <h5 class="fw-bold">Incident & Outage Handling</h5>
     <ul>
        <li>Quick incident reporting from the field</li>
        <li>Automated escalation workflows Root-cause tagging & classification</li>
        <li>Real-time response dashboards</li>
        
     </ul>
      </div>
    </div>
  </div>
            </div>
        </section>
        <section class="py-5">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7" data-aos="fade-right">
                        <h3 class="mb-4 fw-bold">Corporates who have deployed<br/> this application are reaping the <br/>benefits of:</h3>
                        <ul class="list-unstyled">
                            <li class="mb-3">Faster field execution &amp; reduced response times</li>
                            <li class="mb-3">Improved safety, compliance &amp; operational consistency</li>
                            <li class="mb-3">Higher uptime with proactive maintenance</li>
                            <li class="mb-3">Data-driven decision-making at every level</li>
                            <li class="mb-3">Fully configurable, scalable &amp; enterprise-grade security</li>
                        </ul>
                    </div>
                    <div class="col-lg-5 text-center mt-4 mt-lg-0" data-aos="fade-left">
                                                <img src="images/two-workers-tablet-placeholder.png" class="img-fluid" alt="Two field workers looking at a tablet, showcasing data-driven decision making.">
                    </div>
                </div>
            </div>
        </section>
        </div>
<?php include('includes/footer.php')?>