<?php include('includes/header.php')?>
<div class="custom-padding">
<div class="container mb-5">
  <div class="hero-section row align-items-center mx-0 about-right-banner-img">
    <div class="col-lg-7" data-aos="fade-right">
    <h3 class="f27"><strong>ABOUT US</strong></h3>
      <p class="hero-text fw-normal"> As a company that prioritizes technology, we are passionate about helping organizations make bold leaps forward in their ability to innovate, scale, or just completely digitally transform. Our focus is delivering unique technology solutions that solve complex business problems, while maintaining operational efficiencies. By emphasizing quality, we develop scalable IT products that provide lasting value to your organization in today's emerging digital-first world.
</p>
    </div>
    <div class="col-lg-5 text-center " data-aos="fade-left"> </div>
  </div>
</div>
<div class="container values-section py-5">
  <h2 class="section-title" data-aos="fade-up">Our Values</h2>
  <div class="row g-5">
    <div class="col-md-6 d-flex align-items-start gap-3" data-aos="fade-up">
      <div class="icon-circle bg-icon-yellow"><img src="images/innovation.png" width="60" alt="Innovation"/></div>
      <div>
        <h4>Innovation</h4>
        <p>We are passionate about pushing boundaries and embracing the latest technologies to create innovative software solutions. By continuously exploring creative ideas and leveraging cutting-edge tools, we help your business stay ahead of the competition in an ever-evolving digital landscape.
</p>
      </div>
    </div>
    <div class="col-md-6 d-flex align-items-start gap-3" data-aos="fade-up" data-aos-delay="100">
      <div class="icon-circle bg-icon-teal"><img src="images/Integrity.png"  width="60" alt="Integrity"/></div>
      <div>
        <h4>Integrity</h4>
        <p>Trust is the foundation of every successful partnership. Our agency is committed to full transparency, honesty, and ethical IT practices. We believe in building long-term relationships where you feel confident in our reliability and dedication to doing what's right for your business.
</p>
      </div>
    </div>
    <div class="col-md-6 d-flex align-items-start gap-3" data-aos="fade-up" data-aos-delay="200">
      <div class="icon-circle bg-icon-teal"><img src="images/excellence.png" width="60" alt="Excellence"/></div>
      <div>
        <h4>Excellence</h4>
        <p>Quality drives everything we do. From writing clean, efficient code to optimizing system performance, we hold ourselves to the highest standards. Our pursuit of excellence ensures that every software solution we deliver not only meets but surpasses your expectations.
</p>
      </div>
    </div>
    <div class="col-md-6 d-flex align-items-start gap-3" data-aos="fade-up" data-aos-delay="300">
      <div class="icon-circle bg-icon-yellow"><img src="images/customer-centricity.png" width="60" alt="Customer Centricity"/></div>
      <div>
        <h4>Customer-Centricity</h4>
        <p>Your unique needs guide our approach. We don't believe in one-size-fits-all solutions; instead, we tailor our digital strategies to address your specific challenges and goals. By prioritizing your requirements, we create impactful technology that truly transforms your industry presence.</p>
      </div>
    </div>
    <div class="col-md-6 d-flex align-items-start gap-3" data-aos="fade-up" data-aos-delay="300">
      <div class="icon-circle bg-icon-yellow"><img src="images/collaboration.png" width="60" alt="Collaboration"/></div>
      <div>
        <h4>Collaboration</h4>
        <p>We see ourselves as your strategic technology partner, not just a service provider. Our team works closely with you throughout every phase of the project, fostering open communication and shared insights. Together, we turn ideas into reality and drive your business forward with seamless teamwork.</p>
      </div>
    </div>
    <div class="col-md-6 d-flex align-items-start gap-3" data-aos="fade-up" data-aos-delay="300">
      <div class="icon-circle bg-icon-teal"><img src="images/adaptability.png" width="60" alt="Adaptability"/></div>
      <div>
        <h4>Adaptability</h4>
        <p>Flexible and responsible in the fast-changing technology landscape. We are open to embrace new ideas, and respond quickly to evolving circumstances. This empowers our team to learn continuously, adjust strategies with confidence, and transform challenges into opportunities for growth. </p>
      </div>
    </div>
    
  </div>
</div>
<div class="container py-5">
  <div class="text-center mb-5" data-aos="fade-up">
    <h2 class="section-title mb-3">WHY US</h2>
    <p class="mx-auto text-secondary" style="max-width: 700px;"> Our experts combine unique creativity with deep technical knowledge to provide software development services that create new business value.</p>
  </div>
  <div class="row g-4">
    <div class="col-md-4" data-aos="fade-up">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="40px" viewBox="0 76.5 800 650" enable-background="new 0 76.5 800 650" xml:space="preserve">
            <path fill="#FFDA43" d="M693.984,541.563c-33.203-19.219-73.672-14.063-100.938,10l-41.406-23.984V409.063
	c0-12.266-6.563-23.672-17.188-29.766l-106.25-61.172v-52.422c34.531-11.719,59.375-44.375,59.375-82.891
	c0-48.359-39.141-87.5-87.5-87.5s-87.5,39.141-87.5,87.5c0,38.516,24.844,71.172,59.375,82.891v52.422l-106.25,61.172
	c-10.625,6.094-17.188,17.5-17.188,29.766V527.5l-41.406,23.984c-27.266-24.063-67.813-29.219-100.938-10
	c-41.797,24.219-56.016,77.656-32.031,119.453c24.063,41.797,77.266,56.172,118.906,32.031
	c33.203-19.219,48.984-57.031,41.875-92.813l38.047-22.109l109.844,63.281c5.313,3.047,11.25,4.609,17.188,4.609
	s11.875-1.563,17.188-4.609l109.766-63.203L565,600.234c-7.109,35.703,8.75,73.594,41.875,92.813
	c41.641,24.141,94.922,9.844,118.906-32.031C749.844,619.141,735.625,565.703,693.984,541.563L693.984,541.563z M168.203,649.688
	c-17.772,10.293-40.524,4.23-50.818-13.542c-0.04-0.069-0.08-0.139-0.12-0.208c-10.313-17.891-4.219-40.859,13.672-51.172
	c17.772-10.294,40.524-4.23,50.818,13.542c0.04,0.069,0.08,0.139,0.12,0.208C192.188,616.406,186.094,639.375,168.203,649.688z
	 M362.5,182.813c0.423-20.711,17.555-37.157,38.266-36.734c20.115,0.41,36.324,16.619,36.734,36.734
	c-0.423,20.71-17.555,37.157-38.266,36.734C379.119,219.137,362.91,202.928,362.5,182.813z M495.313,531.406L400,586.328
	l-95.313-54.922V421.719L400,366.797l95.313,54.922V531.406L495.313,531.406z M682.734,636.016
	c-10.313,17.891-33.125,24.063-50.938,13.75s-23.984-33.281-13.672-51.172s33.125-24.063,50.938-13.75
	C686.953,595.156,693.047,618.047,682.734,636.016z"/>
          </svg>
        </div>
        <h5 class="fw-bold">Customer-First Approach</h5>
        <p>Every stage of our development process is impacted by the goals of your organization. We take the time needed to comprehend your vision and develop IT solutions designed to provide maximum value and long-term success.</p>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="40px" height="40px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
            <g id="_17_quality">
              <path fill="#FFDA43" d="M514.319,244.419c-1.857-5.574-7.055-9.349-12.929-9.391h-67.64l-20.822-64.236
		c-2.347-7.141-10.038-11.026-17.178-8.679c-4.107,1.35-7.329,4.571-8.679,8.679l-20.823,64.236H298.61
		c-5.875,0.042-11.072,3.817-12.929,9.391c-1.857,5.635,0.187,11.823,5.036,15.243l54.574,39.739l-20.822,64.237
		c-1.845,5.605,0.134,11.761,4.899,15.242c4.812,3.402,11.247,3.402,16.059,0L400,339.141l54.574,39.739
		c2.368,1.624,5.158,2.522,8.029,2.586c2.878-0.022,5.68-0.924,8.029-2.586c4.766-3.481,6.744-9.637,4.899-15.242l-20.822-64.237
		l54.573-39.739C514.132,256.242,516.177,250.055,514.319,244.419z M430.757,283.206c-4.793,3.461-6.823,9.607-5.035,15.243
		l11.023,33.751l-28.716-20.958c-4.797-3.448-11.26-3.448-16.059,0L363.254,332.2l11.024-33.751
		c1.788-5.635-0.243-11.782-5.036-15.243l-28.716-20.958h35.521c5.9,0.035,11.138-3.769,12.929-9.39L400,219.106l11.023,33.751
		c1.792,5.621,7.029,9.425,12.929,9.39h35.521L430.757,283.206z"/>
              <path fill="#FFDA43" d="M400,104.106c-99.508-0.028-180.198,80.617-180.226,180.125c-0.026,93.585,71.601,171.61,164.847,179.572
		c5.171,0.408,10.207,0.68,15.378,0.68c4.627,0,9.391-0.271,14.018-0.68h1.361v-0.137c99.109-8.463,172.593-95.669,164.128-194.779
		C571.547,175.677,493.55,104.079,400,104.106z M533.509,358.875c-0.076,0-0.137,0.062-0.137,0.136
		c-24.721,44.305-69.881,73.391-120.443,77.574l-0.136,0.136h-0.136c-8.511,0.838-17.084,0.792-25.586-0.136
		c-84.148-7.171-146.551-81.199-139.38-165.347c7.17-84.148,81.198-146.55,165.346-139.38
		c84.149,7.17,146.552,81.199,139.381,165.346C550.571,318.872,544.125,339.896,533.509,358.875L533.509,358.875z"/>
              <path fill="#FFDA43" d="M765.821,682.099l-51.172-79.343c-36.609-56.479-73.173-113.049-109.691-169.71
		c2.857-1.089,6.124-2.313,9.391-3.402c14.897-2.983,27.983-11.805,36.337-24.497c4.671-14.349,3.446-29.967-3.402-43.414
		c-3.199-6.965-4.914-14.52-5.035-22.183c3.37-6.551,8.049-12.34,13.745-17.012c12.235-9.266,20.27-23.031,22.319-38.243
		c-2.02-15.184-10.063-28.917-22.319-38.106c-5.676-4.746-10.349-10.575-13.745-17.147c0.121-7.664,1.836-15.218,5.035-22.184
		c6.844-13.399,8.067-28.974,3.402-43.278c-8.377-12.669-21.451-21.483-36.337-24.497c-7.33-1.854-14.221-5.138-20.278-9.663
		c-3.012-6.925-4.675-14.362-4.899-21.911c0.414-15.148-5.217-29.838-15.65-40.829c-13.008-7.657-28.518-9.859-43.143-6.124
		c-7.407,1.529-15.049,1.529-22.455,0c-5.701-4.775-10.376-10.655-13.746-17.284c-6.251-14.029-17.87-24.962-32.254-30.349
		c-14.892-1.28-29.682,3.421-41.101,13.065c-6.182,4.711-13.271,8.094-20.822,9.935c-7.551-1.841-14.641-5.224-20.822-9.935
		c-11.378-9.623-26.116-14.323-40.964-13.065c-14.444,5.34-26.123,16.282-32.391,30.349c-3.375,6.588-7.997,12.458-13.609,17.284
		c-7.453,1.527-15.138,1.527-22.592,0c-14.581-3.737-30.048-1.534-43.006,6.124c-10.552,10.979-16.242,25.743-15.787,40.964
		c-0.139,7.531-1.854,14.948-5.036,21.775c-5.933,4.532-12.747,7.777-20.006,9.526c-14.92,3.017-28.037,11.827-36.473,24.497
		c-4.67,14.35-3.446,29.967,3.402,43.414c3.199,6.965,4.914,14.52,5.036,22.184c-3.397,6.572-8.07,12.402-13.746,17.147
		c-12.256,9.188-20.3,22.922-22.319,38.106c2.049,15.211,10.083,28.977,22.319,38.243c5.696,4.671,10.375,10.461,13.746,17.012
		c-0.122,7.664-1.837,15.218-5.036,22.183c-6.844,13.4-8.068,28.974-3.402,43.278c8.313,12.732,21.417,21.566,36.337,24.497
		c3.13,1.225,6.396,2.313,9.391,3.538c-36.609,56.615-73.173,113.185-109.692,169.71l-51.171,79.343
		c-3.02,4.549-2.966,10.477,0.136,14.97c3.022,4.488,8.433,6.737,13.746,5.717l92.952-17.284l22.592,92
		c1.341,5.253,5.671,9.209,11.023,10.07c0.716,0.157,1.445,0.249,2.178,0.272c4.637,0.031,8.96-2.337,11.432-6.261l146.709-227.141
		c1.089,0.271,2.042,0.952,3.13,1.225c2.229,0.531,4.512,0.806,6.805,0.816c12.493-1.377,24.362-6.182,34.296-13.882
		c6.182-4.711,13.271-8.093,20.822-9.935c7.551,1.842,14.641,5.224,20.822,9.935c11.43,9.723,26.294,14.433,41.236,13.065
		c1.089-0.272,2.042-0.953,2.994-1.225l146.71,227.141c2.471,3.924,6.795,6.292,11.432,6.261c0.732-0.023,1.462-0.115,2.178-0.272
		c5.353-0.861,9.683-4.817,11.023-10.07l22.592-92l92.952,17.284c5.31,0.991,10.705-1.252,13.746-5.717
		C768.788,692.575,768.841,686.647,765.821,682.099z M182.521,740.211l-18.101-73.627c-1.688-7.013-8.553-11.489-15.651-10.207
		l-74.58,13.881l34.023-52.668c34.023-52.805,68.138-105.609,102.343-158.414c0.148,0.626,0.239,1.264,0.272,1.905
		c-0.414,15.148,5.217,29.839,15.651,40.829c13.01,7.65,28.517,9.852,43.142,6.124c7.407-1.529,15.049-1.529,22.456,0
		c5.733,4.744,10.415,10.63,13.746,17.284c2.586,3.946,5.171,7.893,7.894,11.704L182.521,740.211z M459.882,526.406
		c-1.1,1.249-2.508,2.188-4.083,2.723c-3.811,0.816-13.882-5.308-20.414-9.527c-10.232-7.945-22.495-12.85-35.385-14.153
		c-12.89,1.304-25.152,6.208-35.384,14.153c-6.533,4.22-16.604,10.479-20.278,9.663c-1.668-0.639-3.161-1.665-4.355-2.994
		c-4.215-4.717-7.911-9.872-11.023-15.379c-5.632-11.232-14.249-20.696-24.905-27.354c-6.187-2.816-12.94-4.167-19.734-3.947
		c-5.918,0.115-11.826,0.57-17.692,1.361c-8.438,0.953-19.87,2.313-23.136-0.272s-4.627-14.153-5.58-22.592
		c-0.166-12.743-3.89-25.188-10.751-35.929c-1.083-1.358-2.315-2.591-3.674-3.674c-0.52-0.44-1.065-0.85-1.633-1.226l-0.136-0.136
		h-0.136c-8.137-5.95-17.258-10.419-26.947-13.201c-8.029-2.858-18.917-6.668-20.822-10.751c-1.905-3.811,1.905-14.562,4.627-22.456
		c5.452-11.574,7.482-24.464,5.852-37.154c-3.997-11.919-11.315-22.449-21.094-30.349c-5.988-5.988-14.29-14.29-14.29-18.917
		c0-4.627,8.302-12.929,14.29-18.917c9.779-7.9,17.098-18.43,21.094-30.349c1.63-12.689-0.4-25.58-5.852-37.154
		c-2.722-7.893-6.532-18.645-4.627-22.591s12.929-7.757,20.958-10.616c12.268-2.884,23.458-9.211,32.254-18.236
		c6.963-10.651,10.74-23.068,10.887-35.793c0.953-8.438,2.178-19.87,5.58-22.591c3.402-2.722,14.698-1.361,23.136-0.409
		c12.472,2.657,25.438,1.761,37.426-2.585c10.688-6.619,19.314-16.094,24.905-27.355c4.491-7.349,10.751-17.284,15.242-18.237
		c3.811-0.953,13.882,5.444,20.415,9.527C374.848,56.934,387.11,61.839,400,63.142c12.89-1.303,25.152-6.208,35.385-14.154
		c6.532-4.083,16.467-10.343,20.414-9.527c4.491,0.953,10.751,10.888,15.242,18.237c5.591,11.261,14.217,20.736,24.905,27.355
		c11.988,4.346,24.954,5.243,37.426,2.585c8.438-0.953,19.87-2.313,23.137,0.272c3.266,2.586,4.627,14.154,5.579,22.592
		c0.166,12.744,3.89,25.188,10.752,35.929c8.927,9.025,20.188,15.387,32.526,18.373c8.029,2.722,18.917,6.533,20.822,10.615
		c1.905,3.811-1.905,14.563-4.627,22.456c-5.451,11.574-7.482,24.465-5.853,37.154c3.997,11.919,11.315,22.449,21.095,30.349
		c5.988,5.988,14.29,14.29,14.29,18.917c0,4.627-8.302,12.929-14.29,18.917c-9.779,7.9-17.098,18.43-21.095,30.349
		c-1.63,12.689,0.401,25.58,5.853,37.154c2.722,7.894,6.532,18.645,4.627,22.592s-12.929,7.894-20.822,10.615
		c-10.191,2.784-19.754,7.497-28.172,13.882c-1.509,1.349-2.918,2.804-4.219,4.354c-6.963,10.65-10.74,23.069-10.888,35.793
		c-0.952,8.438-2.177,19.87-5.579,22.592s-14.698,1.361-23.137,0.408c-12.466-2.725-25.452-1.828-37.426,2.586
		c-10.656,6.658-19.273,16.122-24.905,27.354C467.896,516.454,464.153,521.656,459.882,526.406z M651.229,656.377
		c-7.097-1.282-13.962,3.194-15.65,10.207l-18.101,73.627L486.284,537.022c2.722-3.812,5.308-7.758,7.893-11.704
		c3.336-6.613,7.963-12.491,13.61-17.284c7.453-1.527,15.138-1.527,22.591,0c14.58,3.737,30.049,1.534,43.006-6.124
		c10.527-10.94,16.217-25.652,15.787-40.829c0.023-0.643,0.115-1.281,0.272-1.905c34.159,52.805,68.273,105.609,102.343,158.414
		l34.023,52.668L651.229,656.377z"/>
            </g>
          </svg>
        </div>
        <h5 class="fw-bold">End-to-End Expertise</h5>
        <p>From IT consulting and design to final deployment, we provide comprehensive software solutions all under one roof. You gain a trusted technology partner capable of managing every stage of your digital evolution.
</p>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="30px" height="30px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
            <path fill="#FFDA43" d="M690.735,574.982c-23.31-23.327-50.546-42.368-80.46-56.247c42.186-34.177,69.099-86.326,69.099-144.809
	c0-103.182-86.048-187.832-189.229-186.249c-101.599,1.583-183.456,84.371-183.456,186.249c0,58.482,27.006,110.632,69.099,144.809
	c-29.92,13.869-57.158,32.91-80.459,56.247c-50.846,50.939-79.715,118.176-81.577,189.882c-0.103,4.113,3.148,7.531,7.261,7.634
	c0.063,0.001,0.126,0.002,0.188,0.002h52.15c4.004,0,7.357-3.166,7.45-7.171c1.769-54.012,23.653-104.578,62.114-142.946
	c39.752-39.964,93.841-62.364,150.21-62.207c56.713,0,110.073,22.07,150.21,62.207c38.367,38.368,60.251,88.935,62.113,142.946
	c0.094,4.005,3.446,7.171,7.45,7.171h52.149c4.115,0.001,7.451-3.333,7.453-7.447c0-0.063-0.002-0.126-0.003-0.188
	C770.636,693.158,741.768,625.922,690.735,574.982z M493.125,493.126c-31.849,0-61.835-12.385-84.278-34.921
	c-22.757-22.578-35.361-53.436-34.921-85.489c0.279-30.545,12.479-60.065,33.804-81.95c22.35-22.909,52.243-35.667,84.185-36.039
	c31.569-0.279,62.207,12.013,84.743,34.083c23.095,22.629,35.76,52.895,35.76,85.116c0,31.849-12.386,61.742-34.922,84.278
	C555.163,480.645,524.783,493.219,493.125,493.126z M259.848,398.512c-0.838-8.102-1.304-16.297-1.304-24.585
	c0-14.807,1.396-29.241,4.004-43.303c0.652-3.353-1.118-6.798-4.191-8.195c-12.665-5.681-24.305-13.503-34.363-23.375
	c-23.963-23.234-37.042-55.479-36.039-88.841c0.838-29.893,12.851-58.296,33.804-79.715c23.001-23.56,53.919-36.412,86.792-36.039
	c29.707,0.279,58.389,11.734,80.087,32.035c7.357,6.891,13.689,14.527,18.997,22.722c1.863,2.887,5.495,4.098,8.661,2.98
	c16.39-5.681,33.711-9.685,51.498-11.547c5.215-0.559,8.194-6.146,5.866-10.802c-30.265-59.879-92.1-101.227-163.62-102.344
	C206.767,25.92,120.719,110.571,120.719,213.66c0,58.482,26.913,110.632,69.099,144.809c-29.614,13.689-56.899,32.594-80.553,56.248
	c-51.032,50.938-79.901,118.175-81.763,189.974c-0.103,4.112,3.148,7.531,7.261,7.634c0.063,0.001,0.125,0.003,0.188,0.003h52.243
	c4.004,0,7.357-3.167,7.45-7.171c1.77-54.013,23.654-104.579,62.114-142.946c27.378-27.379,60.903-46.376,97.501-55.596
	C257.892,405.683,260.313,402.236,259.848,398.512L259.848,398.512z"/>
          </svg>
        </div>
        <h5 class="fw-bold">Commitment to Quality</h5>
        <p>All applications are developed by adhering to strict industry standards and conducting exhaustive tests to evaluate security and scalability.Ensuring quality assurance for optimal performance is an integral part of all that we provide, guaranteeing your organization peace of mind.</p>
      </div>
    </div>
  </div>
  <div class="row g-4 mt-4">
    <div class="col-md-4" data-aos="fade-up">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="40px" height="40px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
            <g>
              <path fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="
		M679.66,437.17C679.66,612.4,538.06,754,362.83,754C187.6,754,46,612.4,46,437.17c0-175.23,141.6-316.83,316.83-316.83v316.83
		H679.66z"/>
              <path fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="
		M754,362.83C754,187.6,612.4,46,437.17,46v316.83H754z"/>
              <line fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="362.83" y1="437.17" x2="138.04" y2="661.96"/>
            </g>
            <line fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="215.92" y1="584.08" x2="382.3" y2="752.23"/>
            <line fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="295.57" y1="504.43" x2="506.2" y2="716.83"/>
            <polyline fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="
	594.7,647.8 435.4,488.5 385.84,438.94 "/>
            <line fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="651.34" y1="566.38" x2="525.67" y2="438.94"/>
          </svg>
        </div>
        <h5 class="fw-bold">Experienced & Skilled Team</h5>
        <p>Our workforce consists of certified developers, engineers, and analysts who bring deep technical knowledge to every project. Their dedication ensures you receive innovative IT results that elevate your brand presence.</p>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="35px" height="35px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
            <path fill="#FFDA43" stroke="#FFDA43" stroke-width="14" stroke-miterlimit="10" d="M66.667,594.133V260.667H700V529
	c11.364,1.218,22.55,3.746,33.333,7.533v-442.4h-200V27.467h-300v66.667h-200v533.2h278.133c5.965-12.378,14.054-23.615,23.899-33.2
	H66.667z M266.667,60.667H500v33.467H266.667V60.667z M66.667,127.333H700v100.133H66.667V127.333z M683.333,560.667
	c-57.849,0.147-106.821,42.732-115,100h-70c-6.692-32.729-32.271-58.308-65-65V459c12.152-2.566,23.569-7.842,33.4-15.434
	l77.866,83.767H500v33.334h100v-100h-33.333V502.1L488.8,418.366c7.259-12.462,11.121-26.611,11.2-41.033
	c-0.01-46.024-37.326-83.326-83.351-83.316c-46.023,0.009-83.325,37.327-83.316,83.35C333.342,416.96,361.207,451.081,400,459
	v136.667c-45.092,9.216-74.174,53.241-64.957,98.333s53.241,74.174,98.333,64.957c32.71-6.686,58.271-32.248,64.957-64.957h70
	c9.334,63.623,68.478,107.634,132.101,98.3c63.623-9.333,107.634-68.477,98.301-132.101
	C790.337,602.96,741.186,560.567,683.333,560.667z M366.667,377.333c0-27.614,22.386-50,50-50s50,22.386,50,50
	c0,27.614-22.386,50-50,50C389.067,427.297,366.703,404.933,366.667,377.333z M416.667,727.333c-27.614,0-50-22.386-50-50
	s22.386-50,50-50s50,22.386,50,50C466.63,704.933,444.266,727.297,416.667,727.333z M683.333,760.667
	c-46.023,0-83.333-37.31-83.333-83.334C600,631.31,637.31,594,683.333,594c46.024,0,83.334,37.31,83.334,83.333
	C766.63,723.342,729.342,760.63,683.333,760.667z M733.333,677.333c0,27.614-22.386,50-50,50s-50-22.386-50-50s22.386-50,50-50
	C710.933,627.37,733.297,649.734,733.333,677.333z"/>
            <path fill="none" d="M0,0h800v800H0V0z"/>
          </svg>
        </div>
        <h5 class="fw-bold">Cutting-Edge Technologies</h5>
        <p>We utilize the latest development tools and automation frameworks to keep your business ahead of the market curve. Whether you need Cloud computing, AI solutions, or RPA integration, prioritizing innovation is our standard.</p>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="35px" height="35px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
            <g>
              <g>
                <path fill="#FFDA43" d="M709.864,390.169L800,323.423L722.088,60.842L321.045,73.695l-38.636,59.997l-137.348-33.036L0,400.136
			l66.077,56.874l-34.888,53.988c-11.019,17.054-14.737,37.375-10.47,57.226c4.266,19.85,16.008,36.849,33.06,47.867
			c12.442,8.04,26.628,12.193,41.1,12.193c3.81,0,7.636-0.302,11.458-0.883c4.839,17.208,15.698,32.794,31.856,43.234
			c12.722,8.222,27.003,12.147,41.129,12.147c3.816,0,7.614-0.322,11.372-0.887c4.997,17.875,16.188,33.125,31.911,43.286
			c12.724,8.222,27.003,12.147,41.13,12.147c24.958,0,49.436-12.258,63.959-34.736l10.366-16.044l60.708,40.247l0.253,0.167
			c12.442,8.041,26.628,12.195,41.1,12.195c5.359,0,10.761-0.57,16.125-1.722c19.851-4.268,36.849-16.01,47.867-33.06
			c7.755-12.001,11.682-25.389,12.102-38.727c3.89-0.228,7.789-0.747,11.672-1.581c19.851-4.268,36.849-16.01,47.867-33.06
			c7.602-11.763,11.726-25.084,12.151-38.729c3.874-0.229,7.755-0.747,11.619-1.578c19.852-4.268,36.85-16.006,47.869-33.06
			c7.762-12.013,11.688-25.417,12.102-38.767c23.395-1.358,45.871-13.452,59.534-34.601c11.019-17.053,14.737-37.375,10.474-57.225
			C726.466,412.933,719.653,400.258,709.864,390.169z M349.717,124.315l334.293-10.712l56.344,189.889l-74.937,55.489
			L378.862,172.403l-81.34,123.455l-0.125,0.192c-7.334,11.344-22.525,14.608-33.869,7.281c-11.344-7.33-14.609-22.523-7.258-33.901
			L349.717,124.315z M115.603,565.545c-7.334,11.346-22.528,14.609-33.867,7.281c-5.495-3.551-9.28-9.029-10.655-15.426
			c-1.373-6.397-0.176-12.945,3.377-18.441l51.517-79.729c4.683-7.245,12.567-11.193,20.612-11.193
			c4.552,0,9.156,1.266,13.256,3.914c5.495,3.552,9.278,9.028,10.653,15.425s0.176,12.947-3.374,18.442L115.603,565.545z
			 M200.017,620.091c-7.334,11.344-22.526,14.606-33.869,7.279c-11.344-7.329-14.609-22.523-7.278-33.867l51.519-79.729
			c4.683-7.245,12.567-11.193,20.612-11.193c4.552,0,9.156,1.266,13.256,3.915c11.344,7.33,14.609,22.523,7.28,33.867
			L200.017,620.091z M335.947,594.906l-51.519,79.729c-7.33,11.347-22.523,14.608-33.866,7.28c-5.495-3.552-9.28-9.03-10.653-15.427
			c-1.375-6.397-0.178-12.945,3.374-18.442l51.519-79.729c3.551-5.495,9.028-9.278,15.425-10.653
			c1.729-0.37,3.469-0.555,5.193-0.555c4.664,0,9.236,1.339,13.246,3.932C340.011,568.37,343.276,583.563,335.947,594.906z
			 M675.763,456.314c-3.552,5.495-9.028,9.277-15.425,10.652c-6.397,1.377-12.947,0.177-18.441-3.373l-17.092-11.044l-0.002-0.001
			l-79.73-51.52l-27.957,43.266l17.094,11.047l62.638,40.476c5.495,3.552,9.278,9.028,10.653,15.425s0.177,12.947-3.373,18.442
			c-3.551,5.495-9.03,9.279-15.426,10.654c-6.398,1.374-12.945,0.177-18.441-3.373l-79.73-51.519l-27.956,43.266l62.636,40.472
			c11.344,7.329,14.609,22.521,7.28,33.867c-3.552,5.495-9.03,9.279-15.425,10.654c-6.398,1.374-12.945,0.177-18.441-3.373
			l-68.059-43.977l-27.957,43.266l50.965,32.931c11.344,7.333,14.61,22.523,7.279,33.869c-3.552,5.495-9.028,9.279-15.425,10.654
			c-6.356,1.366-12.862,0.191-18.336-3.308l-61.064-40.482l13.192-20.419c22.745-35.201,12.612-82.347-22.589-105.091
			c-16.171-10.448-34.858-13.94-52.545-11.271c-4.834-17.224-15.697-32.825-31.866-43.273
			c-16.159-10.44-34.831-13.937-52.508-11.276c-4.999-17.869-16.188-33.113-31.906-43.27c-29.094-18.803-66.341-15.118-91.236,6.601
			l-32.931-28.344l109.711-226.497l79.526,19.126l-39.886,61.936c-22.746,35.202-12.613,82.345,22.589,105.091
			c35.166,22.725,82.253,12.629,105.026-22.488l53.093-80.581l274.797,178.918c5.493,3.552,9.277,9.028,10.652,15.426
			C680.513,444.269,679.314,450.817,675.763,456.314z"/>
              </g>
            </g>
          </svg>
        </div>
        <h5 class="fw-bold">Agile & Efficient Delivery</h5>
        <p>We follow Agile software methodologies to ensure faster project delivery, complete transparency, and adaptability. This ensures your IT projects stay on track, on budget, and aligned with your evolving business needs.</p>
      </div>
    </div>
  </div>
   <div class="row g-4 mt-4">
    <div class="col-md-4" data-aos="fade-up">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="40px" height="40px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
            <g>
              <path fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="
		M679.66,437.17C679.66,612.4,538.06,754,362.83,754C187.6,754,46,612.4,46,437.17c0-175.23,141.6-316.83,316.83-316.83v316.83
		H679.66z"/>
              <path fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="
		M754,362.83C754,187.6,612.4,46,437.17,46v316.83H754z"/>
              <line fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="362.83" y1="437.17" x2="138.04" y2="661.96"/>
            </g>
            <line fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="215.92" y1="584.08" x2="382.3" y2="752.23"/>
            <line fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="295.57" y1="504.43" x2="506.2" y2="716.83"/>
            <polyline fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="
	594.7,647.8 435.4,488.5 385.84,438.94 "/>
            <line fill="none" stroke="#FFDA43" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="651.34" y1="566.38" x2="525.67" y2="438.94"/>
          </svg>
        </div>
        <h5 class="fw-bold">Trust & Credibility</h5>
        <p>We operate with high integrity, boasting over 100 satisfied clients who trust our secure digital services. As a testament to our reliability, we hold a Certificate of Commitment from the Central Vigilance Commission of India, proving that our corporate reputation is paramount.</p>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="35px" height="35px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
            <path fill="#FFDA43" stroke="#FFDA43" stroke-width="14" stroke-miterlimit="10" d="M66.667,594.133V260.667H700V529
	c11.364,1.218,22.55,3.746,33.333,7.533v-442.4h-200V27.467h-300v66.667h-200v533.2h278.133c5.965-12.378,14.054-23.615,23.899-33.2
	H66.667z M266.667,60.667H500v33.467H266.667V60.667z M66.667,127.333H700v100.133H66.667V127.333z M683.333,560.667
	c-57.849,0.147-106.821,42.732-115,100h-70c-6.692-32.729-32.271-58.308-65-65V459c12.152-2.566,23.569-7.842,33.4-15.434
	l77.866,83.767H500v33.334h100v-100h-33.333V502.1L488.8,418.366c7.259-12.462,11.121-26.611,11.2-41.033
	c-0.01-46.024-37.326-83.326-83.351-83.316c-46.023,0.009-83.325,37.327-83.316,83.35C333.342,416.96,361.207,451.081,400,459
	v136.667c-45.092,9.216-74.174,53.241-64.957,98.333s53.241,74.174,98.333,64.957c32.71-6.686,58.271-32.248,64.957-64.957h70
	c9.334,63.623,68.478,107.634,132.101,98.3c63.623-9.333,107.634-68.477,98.301-132.101
	C790.337,602.96,741.186,560.567,683.333,560.667z M366.667,377.333c0-27.614,22.386-50,50-50s50,22.386,50,50
	c0,27.614-22.386,50-50,50C389.067,427.297,366.703,404.933,366.667,377.333z M416.667,727.333c-27.614,0-50-22.386-50-50
	s22.386-50,50-50s50,22.386,50,50C466.63,704.933,444.266,727.297,416.667,727.333z M683.333,760.667
	c-46.023,0-83.333-37.31-83.333-83.334C600,631.31,637.31,594,683.333,594c46.024,0,83.334,37.31,83.334,83.333
	C766.63,723.342,729.342,760.63,683.333,760.667z M733.333,677.333c0,27.614-22.386,50-50,50s-50-22.386-50-50s22.386-50,50-50
	C710.933,627.37,733.297,649.734,733.333,677.333z"/>
            <path fill="none" d="M0,0h800v800H0V0z"/>
          </svg>
        </div>
        <h5 class="fw-bold">Cost-Effective Solutions</h5>
        <p>Our team utilizes smart system architecture and efficient development practices that significantly reduce your long-term IT costs. Based on your request, I have researched the top-ranking SEO keywords for 2025 relevant to your industry and rewritten your entire document.</p>
      </div>
    </div>
    <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
      <div class="why-us-card">
        <div class="why-us-icon">
          <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 width="35px" height="35px" viewBox="0 0 800 800" enable-background="new 0 0 800 800" xml:space="preserve">
            <g>
              <g>
                <path fill="#FFDA43" d="M709.864,390.169L800,323.423L722.088,60.842L321.045,73.695l-38.636,59.997l-137.348-33.036L0,400.136
			l66.077,56.874l-34.888,53.988c-11.019,17.054-14.737,37.375-10.47,57.226c4.266,19.85,16.008,36.849,33.06,47.867
			c12.442,8.04,26.628,12.193,41.1,12.193c3.81,0,7.636-0.302,11.458-0.883c4.839,17.208,15.698,32.794,31.856,43.234
			c12.722,8.222,27.003,12.147,41.129,12.147c3.816,0,7.614-0.322,11.372-0.887c4.997,17.875,16.188,33.125,31.911,43.286
			c12.724,8.222,27.003,12.147,41.13,12.147c24.958,0,49.436-12.258,63.959-34.736l10.366-16.044l60.708,40.247l0.253,0.167
			c12.442,8.041,26.628,12.195,41.1,12.195c5.359,0,10.761-0.57,16.125-1.722c19.851-4.268,36.849-16.01,47.867-33.06
			c7.755-12.001,11.682-25.389,12.102-38.727c3.89-0.228,7.789-0.747,11.672-1.581c19.851-4.268,36.849-16.01,47.867-33.06
			c7.602-11.763,11.726-25.084,12.151-38.729c3.874-0.229,7.755-0.747,11.619-1.578c19.852-4.268,36.85-16.006,47.869-33.06
			c7.762-12.013,11.688-25.417,12.102-38.767c23.395-1.358,45.871-13.452,59.534-34.601c11.019-17.053,14.737-37.375,10.474-57.225
			C726.466,412.933,719.653,400.258,709.864,390.169z M349.717,124.315l334.293-10.712l56.344,189.889l-74.937,55.489
			L378.862,172.403l-81.34,123.455l-0.125,0.192c-7.334,11.344-22.525,14.608-33.869,7.281c-11.344-7.33-14.609-22.523-7.258-33.901
			L349.717,124.315z M115.603,565.545c-7.334,11.346-22.528,14.609-33.867,7.281c-5.495-3.551-9.28-9.029-10.655-15.426
			c-1.373-6.397-0.176-12.945,3.377-18.441l51.517-79.729c4.683-7.245,12.567-11.193,20.612-11.193
			c4.552,0,9.156,1.266,13.256,3.914c5.495,3.552,9.278,9.028,10.653,15.425s0.176,12.947-3.374,18.442L115.603,565.545z
			 M200.017,620.091c-7.334,11.344-22.526,14.606-33.869,7.279c-11.344-7.329-14.609-22.523-7.278-33.867l51.519-79.729
			c4.683-7.245,12.567-11.193,20.612-11.193c4.552,0,9.156,1.266,13.256,3.915c11.344,7.33,14.609,22.523,7.28,33.867
			L200.017,620.091z M335.947,594.906l-51.519,79.729c-7.33,11.347-22.523,14.608-33.866,7.28c-5.495-3.552-9.28-9.03-10.653-15.427
			c-1.375-6.397-0.178-12.945,3.374-18.442l51.519-79.729c3.551-5.495,9.028-9.278,15.425-10.653
			c1.729-0.37,3.469-0.555,5.193-0.555c4.664,0,9.236,1.339,13.246,3.932C340.011,568.37,343.276,583.563,335.947,594.906z
			 M675.763,456.314c-3.552,5.495-9.028,9.277-15.425,10.652c-6.397,1.377-12.947,0.177-18.441-3.373l-17.092-11.044l-0.002-0.001
			l-79.73-51.52l-27.957,43.266l17.094,11.047l62.638,40.476c5.495,3.552,9.278,9.028,10.653,15.425s0.177,12.947-3.373,18.442
			c-3.551,5.495-9.03,9.279-15.426,10.654c-6.398,1.374-12.945,0.177-18.441-3.373l-79.73-51.519l-27.956,43.266l62.636,40.472
			c11.344,7.329,14.609,22.521,7.28,33.867c-3.552,5.495-9.03,9.279-15.425,10.654c-6.398,1.374-12.945,0.177-18.441-3.373
			l-68.059-43.977l-27.957,43.266l50.965,32.931c11.344,7.333,14.61,22.523,7.279,33.869c-3.552,5.495-9.028,9.279-15.425,10.654
			c-6.356,1.366-12.862,0.191-18.336-3.308l-61.064-40.482l13.192-20.419c22.745-35.201,12.612-82.347-22.589-105.091
			c-16.171-10.448-34.858-13.94-52.545-11.271c-4.834-17.224-15.697-32.825-31.866-43.273
			c-16.159-10.44-34.831-13.937-52.508-11.276c-4.999-17.869-16.188-33.113-31.906-43.27c-29.094-18.803-66.341-15.118-91.236,6.601
			l-32.931-28.344l109.711-226.497l79.526,19.126l-39.886,61.936c-22.746,35.202-12.613,82.345,22.589,105.091
			c35.166,22.725,82.253,12.629,105.026-22.488l53.093-80.581l274.797,178.918c5.493,3.552,9.277,9.028,10.652,15.426
			C680.513,444.269,679.314,450.817,675.763,456.314z"/>
              </g>
            </g>
          </svg>
        </div>
        <h5 class="fw-bold">Ongoing Support & Continuous Optimization</h5>
        <p>In order to maintain performance, security, and competitive advantage, we offer committed post-deployment support and continuously optimize your software to adjust to changes in the market.
</p>
      </div>
    </div>
  </div>
</div>
</div>
<?php include('includes/footer.php')?>
