  AOS.init({ offset: 120, duration: 800, once: true });
  $(function () {
 $('.toggle-menu').click(function(){
	$('.exo-menu').toggleClass('display');
	
 });
 $( '#st-stack' ).stackslider();
});
document.addEventListener('DOMContentLoaded', function() {
    // Check if the current environment is likely a touch device (where menu issues arise)
    const isTouchDevice = 'ontouchstart' in window || navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0;

    if (isTouchDevice) {
        // Target all links within the menu that belong to a list item with the 'tap-to-open' class
        const allToggles = document.querySelectorAll('.exo-menu .tap-to-open > a');

        allToggles.forEach(function(link) {
            link.addEventListener('click', function(e) {
                const parentLi = this.parentElement;
                
                // If the link has an href and is NOT the root link (e.g., Products & Solutions)
                // we want to prevent navigation only if it is currently closed and needs to open.
                const hasHref = this.getAttribute('href') && this.getAttribute('href') !== '#';

                // Check if the menu is currently closed or needs to be toggled
                if (!parentLi.classList.contains('open')) {
                    
                    // Prevent navigation only when opening the menu
                    e.preventDefault(); 
                    
                    // --- Closure logic for siblings ---
                    // Close all other open menus at this level
                    const selector = parentLi.parentElement.querySelectorAll('.tap-to-open.open');
                    selector.forEach(function(li) {
                        if (li !== parentLi) {
                            li.classList.remove('open');
                        }
                    });

                    // Open the current menu
                    parentLi.classList.add('open');

                } else {
                    // If the menu is already open
                    if (hasHref) {
                        // If it has an HREF, allow the default behavior (navigate)
                        return true; 
                    } else {
                        // If it doesn't have an HREF (like "About Us"), close it on the second tap
                        e.preventDefault(); 
                        parentLi.classList.remove('open');
                    }
                }
            });
        });
    }
});